<?php
require_once dirname(__DIR__) . '/config/db.php';

try {
    // Drop existing table if it exists
    $pdo->exec("DROP TABLE IF EXISTS system_logs");
    
    // Create new table with updated structure
    $pdo->exec("
        CREATE TABLE system_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NULL,
            action VARCHAR(50) NOT NULL,
            details TEXT NULL,
            module VARCHAR(50) NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
    
    echo "Successfully updated system_logs table structure\n";
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 